# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 4
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR4_strategy.txt
# LLM Suggested Fallback: Not Provided

def harmonious_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    if current_round == 1:
        return "C"
    
    if current_round <= 3:
        return opp_history[-1]
    
    if current_round <= 7:
        if all(move == "C" for move in opp_history[-2:]):
            return "D"
        else:
            return opp_history[-1]
    
    if current_round >= 8:
        if "random.random() < 0.6" in opponent_program_code:
            return "D"
        elif current_round == 10 and opp_history[-1] == "C" and opp_history[-2] == "C":
            return "C"
        else:
            return "D"
    
    return "C"